<?php
/* --------------------------------------------------------------
 AbstractPlugin.php 2020-04-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\Plugins;

/**
 * Class AbstractPlugin
 * @package Gambio\Core\Application\Plugins
 */
abstract class AbstractPlugin implements Plugin
{
    /**
     * @inheritDoc
     */
    public function serviceProviders(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function eventListeners(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function commandHandlers(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getRoutes(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function postRoutes(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function putRoutes(): ?array
    {
        return null;
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteRoutes(): ?array
    {
        return null;
    }
}